// ContentsEsc_g.cpp : CContentsEsc_g Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEsc_g, CObject, 1)



// Serialize draw data
void CContentsEsc_g::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEsc_g::Draw(CDC* pDC)
{
	CGpWinPen Pen( m_Data.cDisplayColor,m_Data.cLineStyle) ;
	CBrush Brush ;	LOGBRUSH b =
	{	//NULL Bursh
		BS_NULL,0,0
	};
	Brush.CreateBrushIndirect(&b);

	CPen* pOldPen         = pDC->SelectObject((CPen* )&Pen);
	int OldBkMode         = pDC->SetBkMode( OPAQUE );
	COLORREF OldBkColor   = pDC->SetBkColor(GpToWinColor(m_Data.cBackColor));
	CBrush* pOldBrush     = pDC->SelectObject((CBrush* )&Brush);
	COLORREF OldTextColor = pDC->SetTextColor(GpToWinColor(m_Data.cDisplayColor));

	AnglePie(pDC,m_Data.iX1,m_Data.iY1,m_Data.iRadius,m_Data.iStartAngle,m_Data.iEndAngle) ;

	pDC->SetBkMode(OldBkMode );
	pDC->SetBkColor( OldBkColor );
	pDC->SelectObject(pOldPen);
	pDC->SelectObject(pOldBrush);
	pDC->SetTextColor(OldTextColor);
}

// Transmit the data to GP
int CContentsEsc_g::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_g(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.cLineStyle,m_Data.iX1,m_Data.iY1,m_Data.iRadius,m_Data.iStartAngle,m_Data.iEndAngle)) ;
}
